/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.entity.monster.adapted;

import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIAttackMeleeNotGround;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIAttackProjectile;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIFlightAttack;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIFlightLimits;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityCanShoot;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityCutomAttack;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPAdapted;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityEmana;
import com.dhanantry.scapeandrunparasites.entity.projectile.EntityProjectileNade;
import com.dhanantry.scapeandrunparasites.entity.projectile.EntityProjectileSpineball;
import com.dhanantry.scapeandrunparasites.init.SRPSounds;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventEntity;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventWorld;
import com.dhanantry.scapeandrunparasites.util.SRPAttributes;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigMobs;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityEmanaAdapted
extends EntityPAdapted
implements EntityCutomAttack,
EntityCanShoot {
    protected static final DataParameter<Byte> VEX_FLAGS = EntityDataManager.func_187226_a(EntityEmanaAdapted.class, (DataSerializer)DataSerializers.field_187191_a);
    private int count;

    public EntityEmanaAdapted(World worldIn) {
        super(worldIn);
        this.field_70765_h = new AIMoveControl(this);
        this.func_70105_a(1.3f, 2.9f);
        this.func_189654_d(true);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.folow);
        this.borderOrb = -1;
        if (SRPConfigMobs.emanaMaxY != 256) {
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFlightLimits(this, SRPConfigMobs.emanaMaxY, true));
        }
        this.adaptationCap = 0.95f;
    }

    @Override
    public int getParasiteIDRegister() {
        return 55;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFlightAttack(this, SRPConfig.adaptedFollow));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIChargeAttack());
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIMoveRandom());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackProjectile(this, 60, 20, 2, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMeleeNotGround(this, 2.5, 16.0, 0.04, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(SRPAttributes.EMANA_HEALTH + SRPAttributes.EMANA_A_HEALTH);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(SRPAttributes.EMANA_ARMOR + SRPAttributes.EMANA_A_ARMOR);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(SRPAttributes.EMANA_KD_RESISTANCE + SRPAttributes.EMANA_A_KD_RESISTANCE);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(SRPConfig.adaptedFollow);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(SRPAttributes.EMANA_A_MELLE);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70122_E && !this.field_70170_p.field_72995_K) {
            this.field_70765_h.func_75642_a(this.field_70165_t, this.field_70163_u + 5.0, this.field_70161_v, 0.5);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_189654_d(true);
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @Override
    public boolean attackEntityAsMobAOE(Entity entityIn) {
        return this.func_70652_k(entityIn);
    }

    public float func_70047_e() {
        return 2.1f;
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            if (SRPConfigWorld.coloniesActivated) {
                if (ParasiteEventWorld.numberofColonies(this.field_70170_p) >= 1) {
                    ParasiteEventEntity.checkColony(this.field_70170_p, cause, this);
                    ParasiteEventEntity.spawnNext(this, new EntityEmana(this.field_70170_p), true, false);
                } else {
                    super.func_70645_a(cause);
                }
            } else {
                super.func_70645_a(cause);
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return SRPSounds.AEMANA_GROWL;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        if (this.field_70146_Z.nextBoolean() && this.getHitStatus() > 0) {
            return SRPSounds.MOBSILENCE;
        }
        return SRPSounds.AEMANA_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SRPSounds.AEMANA_DEATH;
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
        this.func_145775_I();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VEX_FLAGS, (Object)0);
    }

    public static void registerFixesEmana(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityEmanaAdapted.class);
    }

    private boolean getVexFlag(int mask) {
        byte i = (Byte)this.field_70180_af.func_187225_a(VEX_FLAGS);
        return (i & mask) != 0;
    }

    private void setVexFlag(int mask, boolean value) {
        int i = ((Byte)this.field_70180_af.func_187225_a(VEX_FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.field_70180_af.func_187227_b(VEX_FLAGS, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.getVexFlag(1);
    }

    public void setCharging(boolean charging) {
        this.setVexFlag(1, charging);
    }

    public EntityFireball getProj(double accelX, double accelY, double accelZ) {
        float pit = 1.0f;
        if (this.count == 3) {
            pit = 2.0f;
        }
        this.func_184185_a(SRPSounds.EMANA_SHOOTING, 2.0f, pit);
        if (this.count >= 3) {
            this.count = 0;
            return new EntityProjectileNade(this.field_70170_p, (EntityLivingBase)this, accelX, accelY, accelZ, 4, 100);
        }
        EntityProjectileSpineball ball = new EntityProjectileSpineball(this.field_70170_p, (EntityLivingBase)this, accelX, accelY, accelZ, SRPAttributes.EMANA_A_RANGED_DAMAGE);
        ball.setDurationAmplifier(SRPConfigMobs.emanaPoisonDuration * 2, SRPConfigMobs.emanaPoisonAmplifier + 1);
        ball.setGearDamage(SRPConfigMobs.emanaadaptedgeard);
        return ball;
    }

    @Override
    public void playProjSound() {
        ++this.count;
        if (this.count == 3) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)100);
            float v = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f + 2.0f;
            this.func_184185_a(this.func_184601_bQ(DamageSource.field_76377_j), 4.0f, v);
            return;
        }
        this.func_184185_a(SRPSounds.AEMANA_SHOOTINGPOST, 2.0f, 1.0f);
    }

    class AIChargeAttack
    extends EntityAIBase {
        public AIChargeAttack() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (EntityEmanaAdapted.this.func_70638_az() != null && !EntityEmanaAdapted.this.func_70605_aq().func_75640_a() && EntityEmanaAdapted.this.field_70146_Z.nextInt(7) == 0) {
                return EntityEmanaAdapted.this.func_70068_e((Entity)EntityEmanaAdapted.this.func_70638_az()) > 4.0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return EntityEmanaAdapted.this.func_70605_aq().func_75640_a() && EntityEmanaAdapted.this.isCharging() && EntityEmanaAdapted.this.func_70638_az() != null && EntityEmanaAdapted.this.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            EntityLivingBase entitylivingbase = EntityEmanaAdapted.this.func_70638_az();
            Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
            EntityEmanaAdapted.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.5);
            EntityEmanaAdapted.this.setCharging(true);
        }

        public void func_75251_c() {
            EntityEmanaAdapted.this.setCharging(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = EntityEmanaAdapted.this.func_70638_az();
            if (entitylivingbase != null && entitylivingbase.func_70089_S()) {
                if (EntityEmanaAdapted.this.func_174813_aQ().func_72326_a(entitylivingbase.func_174813_aQ())) {
                    EntityEmanaAdapted.this.func_70652_k((Entity)entitylivingbase);
                    EntityEmanaAdapted.this.setCharging(false);
                } else {
                    double d0 = EntityEmanaAdapted.this.func_70068_e((Entity)entitylivingbase);
                    if (d0 < 9.0) {
                        Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
                        EntityEmanaAdapted.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.5);
                    }
                }
            }
        }
    }

    class AIMoveRandom
    extends EntityAIBase {
        public AIMoveRandom() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return !EntityEmanaAdapted.this.func_70605_aq().func_75640_a() && EntityEmanaAdapted.this.field_70146_Z.nextInt(7) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = new BlockPos((Entity)EntityEmanaAdapted.this);
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityEmanaAdapted.this.field_70146_Z.nextInt(15) - 7, EntityEmanaAdapted.this.field_70146_Z.nextInt(11) - 5, EntityEmanaAdapted.this.field_70146_Z.nextInt(15) - 7);
                if (!EntityEmanaAdapted.this.field_70170_p.func_175623_d(blockpos1)) continue;
                EntityEmanaAdapted.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 0.25);
                if (EntityEmanaAdapted.this.func_70638_az() != null) break;
                EntityEmanaAdapted.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityEmanaAdapted vex) {
            super((EntityLiving)vex);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityEmanaAdapted.this.field_70165_t;
                double d1 = this.field_75647_c - EntityEmanaAdapted.this.field_70163_u;
                double d2 = this.field_75644_d - EntityEmanaAdapted.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityEmanaAdapted.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityEmanaAdapted.this.field_70159_w *= 0.5;
                    EntityEmanaAdapted.this.field_70181_x *= 0.5;
                    EntityEmanaAdapted.this.field_70179_y *= 0.5;
                } else {
                    EntityEmanaAdapted.this.field_70159_w += d0 / d3 * 0.05 * this.field_75645_e;
                    EntityEmanaAdapted.this.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                    EntityEmanaAdapted.this.field_70179_y += d2 / d3 * 0.05 * this.field_75645_e;
                    if (EntityEmanaAdapted.this.func_70638_az() == null) {
                        EntityEmanaAdapted.this.field_70761_aq = EntityEmanaAdapted.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityEmanaAdapted.this.field_70159_w, (double)EntityEmanaAdapted.this.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = EntityEmanaAdapted.this.func_70638_az().field_70165_t - EntityEmanaAdapted.this.field_70165_t;
                        double d5 = EntityEmanaAdapted.this.func_70638_az().field_70161_v - EntityEmanaAdapted.this.field_70161_v;
                        EntityEmanaAdapted.this.field_70761_aq = EntityEmanaAdapted.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }
}

